// Abre o crea una base de datos llamada "mi_base_de_datos" con una versión específica
const request = indexedDB.open('mi_base_de_datos', 1);

// Maneja el evento "onupgradeneeded" para crear tablas y definir el esquema de la base de datos
request.onupgradeneeded = (event) => {
  const db = event.target.result;

  // Crea una tabla llamada "configuracion" solo si no existe
  if (!db.objectStoreNames.contains('configuracion')) {
    const configuracionStore = db.createObjectStore('configuracion', { keyPath: 'id', autoIncrement: true });
    configuracionStore.createIndex('telefono', 'telefono', { unique: true });
  }
};

// Maneja el evento "onsuccess" para realizar operaciones en la base de datos
request.onsuccess = (event) => {
  const db = event.target.result;

  // Abre una transacción para realizar operaciones en la tabla "configuracion"
  const transaction = db.transaction(['configuracion'], 'readwrite');
  const configuracionStore = transaction.objectStore('configuracion');

  // Inserta un registro en la tabla "configuracion"
  const nuevoRegistro = { telefono: '56993063654' };
  configuracionStore.add(nuevoRegistro, 1); // 1 es el valor del campo "id"

  // Maneja eventos de éxito y error de la transacción
  transaction.oncomplete = () => {
    alert('Registro insertado con éxito.');
  };

  transaction.onerror = (event) => {
    alert('Error al insertar el registro:', event.target.error);
  };
};

// Maneja el evento "onerror" para manejar errores en la base de datos
request.onerror = (event) => {
  alert('Error al abrir la base de datos:', event.target.error);
};
