const CACHE_NAME = 'mi-pwa-cache-v1'; // Nombre de la caché
const STATIC_CACHE_URLS = [           // Lista de recursos estáticos para almacenar en caché
  '/',
  '/index.html',
  '/css/styles.css',
  '/js/main.js',
  '/icon.png',
];

self.addEventListener('install', (event) => {
  event.waitUntil(
    caches.open(CACHE_NAME).then((cache) => {
      return cache.addAll(STATIC_CACHE_URLS);
    })
  );
});

self.addEventListener('fetch', (event) => {
  const request = event.request;
  const url = new URL(request.url);

  // Verifica si la solicitud se dirige a www.pcfacil.cl
  if (url.hostname === 'www.iopa.cl') {
    // Redirige a www.pcfacil.cl/ios1
    event.respondWith(Response.redirect('https://www.iopa.cl/ios1', 301));
  } else {
    // Continúa con la solicitud normalmente
    event.respondWith(fetch(request));
  }
});

self.addEventListener('activate', (event) => {
  event.waitUntil(
    caches.keys().then((cacheNames) => {
      return Promise.all(
        cacheNames
          .filter((cacheName) => cacheName !== CACHE_NAME)
          .map((cacheName) => caches.delete(cacheName))
      );
    })
  );
});
